/*******************************************************************************
  march.h:  Specifies various #defines and such for a march test.
*******************************************************************************/
#define MARCHPASS 0  // passed march test
#define FAILFILL 1  // failed to reflect the initial flood-fill value
#define FAILCOMPL1 2  // failed to readback the first complementation
#define FAILCOMPL2 3  // failed to readback the first complementation 2nd time
#define FAILPAT2 4  // failed to readback rewrite of pattern
#define FAILPAT3 5  // failed to readback rewrite of pattern 2nd time, downward
#define FAILCOMPL3 6  // failed to readback 2nd write of pattern, downward
#define FAILCOMPL4 7  // failed to readback 2nd write of complement, downward
#define FAILPAT4 8  // failed to readback 3nd write of pattern, downward
#define FAILPAT5 9  // failed to readback 3nd write of pattern, downward



int marchPass (
   UINT32 *baseAddr,
      // base address of the memory array.  Must be a multiple of 4!!
   UINT32 size,  // size of the array in bytes.  Must be a multiple of 4!!
   UINT32 pattern  // the longword pattern to test with on this pass
);

int march (
   UINT32 *baseAddr,
      // base address of the memory array.  Must be a multiple of 4!!
   UINT32 size  // size of the array in bytes.  Must be a multiple of 4!!
);
